//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using Framefield.Core;

namespace Framefield.Core.ID9d818bd8_12b4_4bd9_9ae2_d697d2963535
{
    public class Class_StopWatch__2_ : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            ResetTrigger = 0,
            Running = 1
        }
        //<<< _inputids        

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var ResetTrigger = inputs[(int)InputId.ResetTrigger].Eval(context).Value;
            var Running = inputs[(int)InputId.Running].Eval(context).Value;
            //<<< _params
            
            if (_lastTime == float.NaN)
            {
                _lastTime = context.Time;
            }
            if (_lastTime != context.Time)
            {
                _duration += context.Time - _lastTime;
                _lastTime = context.Time;
                Changed = false;
            }

            bool resetTriggerUp = _oldResetTrigger < 0.5f && ResetTrigger > 0.5f;
            bool resetTriggerDown = _oldResetTrigger > 0.5f && ResetTrigger < 0.5f;
            _oldResetTrigger = ResetTrigger;
            if (resetTriggerUp)
            {
                //Logger.Warn(this,"Reset");
                _duration = 0;
            }

            context.Value = _duration;
            return context;
        }

        float _oldResetTrigger;
        float _lastTime = 0;
        float _duration = 0;
    }
}


